/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import club.sk1er.org.apache.commons.lang3.StringUtils;
import java.util.Calendar;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TestHackHelper;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractFutureDateFilter
extends RuleFilter {
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d+).*");

    protected int getDayOfMonth(String localizedDayOfMonth) {
        return 0;
    }

    protected abstract int getMonth(String var1);

    protected abstract Calendar getCalendar();

    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> args, AnalyzedTokenReadings[] patternTokens) {
        Calendar dateFromDate = this.getDate(args);
        Calendar currentDate = this.getCalendar();
        if (TestHackHelper.isJUnitTest()) {
            currentDate = new Calendar.Builder().setDate(2014, 0, 1).build();
        }
        try {
            if (dateFromDate.after(currentDate)) {
                return match;
            }
            return null;
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    protected String getRequired(String key, Map<String, String> map) {
        String result = map.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Missing key '" + key + "'");
        }
        return result;
    }

    private Calendar getDate(Map<String, String> args) {
        int year = Integer.parseInt(this.getRequired("year", args));
        int month = this.getMonthFromArguments(args);
        int dayOfMonth = this.getDayOfMonthFromArguments(args);
        Calendar calendar = this.getCalendar();
        calendar.setLenient(false);
        calendar.set(year, month, dayOfMonth, 0, 0, 0);
        return calendar;
    }

    private int getDayOfMonthFromArguments(Map<String, String> args) {
        String dayOfMonthString = this.getRequired("day", args);
        Matcher matcherDayOfMonth = DAY_OF_MONTH_PATTERN.matcher(dayOfMonthString);
        int dayOfMonth = matcherDayOfMonth.matches() ? Integer.parseInt(matcherDayOfMonth.group(1)) : this.getDayOfMonth(dayOfMonthString);
        return dayOfMonth;
    }

    private int getMonthFromArguments(Map<String, String> args) {
        String monthStr = this.getRequired("month", args);
        int month = StringUtils.isNumeric(monthStr) ? Integer.parseInt(monthStr) : this.getMonth(monthStr);
        return month - 1;
    }
}

